package ibase.webitm.ejb.wsfa.transactions;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;

import ibase.webitm.utility.ITMException;

public class MarketingCampaignPreSend extends ActionHandlerEJB {
	ValidatorEJB validatorEJB = new ValidatorEJB();
	E12GenericUtility genericUtility = new E12GenericUtility();

	private String buildMailXMLStr(HashMap<String, Object> mailFormatDetails, UserInfoBean userInfo) {

		BaseLogger.log("2", null, null,
				"sendEmailToMe calling buildMailXMLStr-----------------[" + mailFormatDetails + "  ]");

		String mailXMLStr = "";

		// Fetch mail format details from the database
		String emailID = mailFormatDetails.get("SEND_TO").toString();
		BaseLogger.log("3", null, null, "emailID [" + emailID + "]");

		String body = mailFormatDetails.get("BODY").toString();
		BaseLogger.log("3", null, null, "body [" + body + "]");

		String formatCode = "";

		String system = mailFormatDetails.get("SUBJECT").toString();
		BaseLogger.log("3", null, null, "system [" + system + "]");

		String objName = "";
		String workDateApp = "";
		try {
			BaseLogger.log("2", null, null, "Inside try block method: buildMailXMLStr ---");

			mailXMLStr = "";

			mailXMLStr += "<ROOT>";
			mailXMLStr += "<TRANS_INFO>";
			mailXMLStr += "<OBJ_NAME><![CDATA[" + objName + "]]></OBJ_NAME>";
			mailXMLStr += "<REF_SER><![CDATA[]]></REF_SER>";
			mailXMLStr += "<REF_ID><![CDATA[" + workDateApp + "]]></REF_ID>";
			mailXMLStr += "<LINE_NO><![CDATA[1]]></LINE_NO>";
			mailXMLStr += "</TRANS_INFO>";
			mailXMLStr += "<EMAIL_TYPE><![CDATA[]]></EMAIL_TYPE>";
			mailXMLStr += "<ENTITY_CODE><![CDATA[]]></ENTITY_CODE>";
			mailXMLStr += "<FORMAT_CODE><![CDATA[" + formatCode + "]]></FORMAT_CODE>";
			mailXMLStr += "<LINK_ADDR><![CDATA[]]></LINK_ADDR>";
			mailXMLStr += "<TO_ADD><![CDATA[" + emailID + "]]></TO_ADD>";
			mailXMLStr += "<CC_ADD><![CDATA[" + mailFormatDetails.get("COPY_TO") + "]]></CC_ADD>";
			mailXMLStr += "<BCC_ADD><![CDATA[" + mailFormatDetails.get("BLIND_COPY") + "]]></BCC_ADD>";
			mailXMLStr += "<BODY_TEXT><![CDATA[" + body + "]]></BODY_TEXT>";
			mailXMLStr += "<SUBJECT><![CDATA[" + mailFormatDetails.get("SUBJECT") + "]]></SUBJECT>";
			mailXMLStr += "</ROOT>";

			System.out.println("mailXMLStr....::" + mailXMLStr);

		} catch (Exception e) {
			BaseLogger.log("0", null, null, "Exception from buildMailXMLStr [" + system + "]");
			e.printStackTrace();
		}

		return mailXMLStr;
	}

	public String sendEmail(String tranId, String xtraParams, String forcedFlag) throws Exception {
		String userId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String formatCode = "";
		String subject = "";
		String bodyText = "";
		String mailListName = "";
		String retString = "";
		int batchCount = 0;
		DateFormat dtFormat = new SimpleDateFormat("dd-MMM-yy");
		java.util.Date date = Calendar.getInstance().getTime();
		String currentDate = dtFormat.format(date);
		List<String> mailList = new ArrayList<String>();
		UserInfoBean userInfo = getUserInfo();
		System.out.println("********************userinfo****************" + userInfo);
		try {
			conn = getConnection();
			userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			BaseLogger.log("3", null, null, "user id2 [" + userId + "]");
			BaseLogger.log("3", null, null, "tran id2 [" + tranId + "]");

			sql = "select mailing_list from mktg_campaign_det where campaign_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				mailListName = rs.getString("mailing_list");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "mail list name [" + mailListName + "]");

			// Used to get all email Id against the mail_list_id(campaign_template) from
			// mailing_list_det and store it in Logs table
			sql = "select email_id from mailing_list_det where mail_list_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, mailListName);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				mailList.add(rs.getString("email_id"));
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "mail list [" + mailList + "]");

			conn.setAutoCommit(false);
			// To add entries in mktg_cmpaign_log table
			for (String emilId : mailList) {
				sql = "insert into mktg_campaign_log (campaign_id,email_id,status,status_date) values (?,?,'N',?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				pstmt.setString(2, emilId);
				pstmt.setString(3, currentDate);

				BaseLogger.log("3", null, null, "email for insert [" + emilId + "]");

				rs = pstmt.executeQuery();
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			}
			conn.commit();

			sql = "select campaign_template,batch_count from mktg_campaign where campaign_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				formatCode = rs.getString("campaign_template");
				batchCount = rs.getInt("batch_count");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "format code [" + formatCode + "]");

			sql = "select subject,body_text from mail_format where format_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, formatCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				subject = rs.getString("subject");
				bodyText = rs.getString("body_text");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "subject [" + subject + "]");
			BaseLogger.log("3", null, null, "body text [" + bodyText + "]");

			// Calling method to send mail according to batch count
			retString = sendEmailWithBatchCount(mailList, batchCount, subject, bodyText, userInfo, tranId);

		} catch (Exception e) {
			System.out
					.println("Exception :MarketingCampaignPreSend :sendMail(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return retString;

	}

	public List<String> getUpdatedEmail(String tranId, int batchCount) {
		List<String> mailListForMailSend = new ArrayList<>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";

		try {
			conn = getConnection();
			conn.setAutoCommit(false); // Begin transaction

			// Get email IDs with status 'N'
			sql = "SELECT email_id FROM mktg_campaign_log WHERE status = 'N' AND campaign_id = ? FETCH NEXT ? ROWS ONLY";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			pstmt.setInt(2, batchCount); // Adjust according to your logic
			rs = pstmt.executeQuery();
			while (rs.next()) {
				mailListForMailSend.add(rs.getString("email_id"));
			}
			BaseLogger.log("3", null, null, "Mail list for mail sending [" + mailListForMailSend + "]");

			conn.commit();
		} catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("0", null, null, "Exception in getUpdatedEmail: " + e.getMessage());
			if (conn != null) {
				try {
					conn.rollback(); // Rollback on exception
					BaseLogger.log("0", null, null, "Transaction rolled back due to exception.");
				} catch (SQLException se) {
					se.printStackTrace();
				}
			}
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return mailListForMailSend;
	}

	public String sendEmailWithBatchCount(List<String> mailList2, int batchCount, String subject, String bodyText,
			UserInfoBean userInfo, String tranId) {
		BaseLogger.log("3", null, null, "sendEmailWithBatchCount method calling [" + batchCount + "]");

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String fromEmailId = "",retString = "";
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		List<String> mailListForMailSend;
		boolean updateFlag = false;


		try {
			conn = getConnection();
			conn.setAutoCommit(false); // Begin transaction

			while (true) {
				mailListForMailSend = getUpdatedEmail(tranId, batchCount);

				if (mailListForMailSend.isEmpty()) {
					updateFlag = true;
					break; 
				}

				int totalMails = mailListForMailSend.size();
				int totalBatches = (int) Math.ceil((double) totalMails / batchCount);

				for (int i = 0; i < totalBatches; i++) {
					int start = i * batchCount;
					int end = Math.min(start + batchCount, totalMails);
					List<String> batchList = mailListForMailSend.subList(start, end);

					for (String emailId : batchList) {
						BaseLogger.log("3", null, null, "Single emailId [" + emailId + "]");

						HashMap<String, Object> mailFormatDetails = new HashMap<>();
						mailFormatDetails.put("SEND_TO", emailId);
						mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
						mailFormatDetails.put("SUBJECT", subject);
						mailFormatDetails.put("BODY", bodyText);

						EMail email = new EMail();
						email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString());
						BaseLogger.log("3", null, null, "Mail from [" + fromEmailId + "]");

						String mailXMLStr = buildMailXMLStr(mailFormatDetails, userInfo);
						String emailStatus;
						try {
							emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
							BaseLogger.log("3", null, null, "Email status for [" + emailId + "]: " + emailStatus);
						} catch (Exception e) {
							BaseLogger.log("3", null, null,
									"Error sending email to [" + emailId + "]: " + e.getMessage());
							continue; // Proceed to the next email
						}

						// Update the log
						sql = "UPDATE mktg_campaign_log SET status = 'S' WHERE email_id = ? AND campaign_id = ?";
						try (PreparedStatement updatePstmt = conn.prepareStatement(sql)) {
							updatePstmt.setString(1, emailId);
							updatePstmt.setString(2, tranId);
							int affectedRows = updatePstmt.executeUpdate();
							BaseLogger.log("3", null, null,
									"Rows affected by update for emailId [" + emailId + "]: " + affectedRows);
						} catch (SQLException e) {
							BaseLogger.log("3", null, null,
									"Error updating log for emailId [" + emailId + "]: " + e.getMessage());
							conn.rollback(); // Rollback on error
						}

						conn.commit(); // Commit the transaction
					}
				}
				
			}
			if(updateFlag)
			{
				retString = itmDBAccessEJB.getErrorString("","VTMAILSUCC","","",conn); 
				return retString;
			}
		} catch (Exception e) {
			e.printStackTrace();
			BaseLogger.log("0", null, null, "Exception during email processing: " + e.getMessage());
			if (conn != null) {
				try {
					conn.rollback(); // Rollback on exception
					BaseLogger.log("0", null, null, "Transaction rolled back due to exception.");
				} catch (SQLException se) {
					se.printStackTrace();
				}
			}
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return retString;
	}

	public String sendEmailToMe(String tranId, String xtraParams, String forcedFlag) {
		String userId = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String userEmail = "";
		String formatCode = "";
		String subject = "";
		String bodyText = "";

		UserInfoBean userInfo = getUserInfo();
		System.out.println("********************userinfo****************" + userInfo);
		try {
			conn = getConnection();
			userId = validatorEJB.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			BaseLogger.log("3", null, null, "user id [" + userId + "]");
			BaseLogger.log("3", null, null, "tran id [" + tranId + "]");

			sql = "select email_id from users where code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, userId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				userEmail = rs.getString("email_id");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "user email [" + userEmail + "]");

			sql = "select campaign_template from mktg_campaign where campaign_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				formatCode = rs.getString("campaign_template");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "format code [" + formatCode + "]");

			sql = "select subject,body_text from mail_format where format_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, formatCode);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				subject = rs.getString("subject");
				bodyText = rs.getString("body_text");
			}
			if (rs != null) {
				rs.close();
				rs = null;
			}
			if (pstmt != null) {
				pstmt.close();
				pstmt = null;
			}
			BaseLogger.log("3", null, null, "subject [" + subject + "]");
			BaseLogger.log("3", null, null, "body text [" + bodyText + "]");

			HashMap<String, Object> mailFormatDetails = new HashMap<>();
			mailFormatDetails.put("SEND_TO", userEmail);
			mailFormatDetails.put("MAIL_SERVER", "192.168.137.1");
			mailFormatDetails.put("SUBJECT", subject);
			mailFormatDetails.put("BODY", bodyText);

			EMail email = new EMail();
			email.setMailFrom(mailFormatDetails.get("MAIL_SERVER").toString()); // Set the email sender address
			System.out.println("getMailFrom1....::" + email.getMailFrom());
			String mailXMLStr = buildMailXMLStr(mailFormatDetails, userInfo);
			String emailStatus = email.sendMail(mailXMLStr, "ITM", userInfo);
			System.out.println("emailStatus....::" + emailStatus);
		} catch (Exception e) {
			System.out.println("Exception :SfaTime :itemChanged(Document,String):" + e.getMessage() + ":");
			e.printStackTrace();
		} finally {
			closeResources(rs, pstmt, conn);
		}
		return "<tran_id>" + tranId + "</tran_id>";

	}
	
	private void closeResources(ResultSet rs, PreparedStatement pstmt, Connection conn) {
		if (rs != null) {
			try {
				rs.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (pstmt != null) {
			try {
				pstmt.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
		if (conn != null) {
			try {
				conn.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}
	}

}